# **smyApps4.2authtime接口说明文档 V1.0**



## 1.  RESTful API 设计规范与约定说明

### 1.1  **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供Document、表单、视图的信息，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/documents

-   https://api.example.com/runtime/forms

-   https://api.example.com/runtime/views
```

以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：

```
PUT /gists/:id/star
```

并且取消星操作：

```
DELETE /gists/:id/star
```

举例来说，有一组API分别提供执行操作按钮的执行前、执行后脚本和业务处理行为，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/activitys/{id}/excute

-   https://api.example.com/runtime/activitys/{id}/beforactionscript

-   https://api.example.com/runtime/activitys/{id}/afteractionscript
```

### 1.2  **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。

```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```

下面是一些例子。

```
-   GET /runtime/documents：获取Document集合

-   POST /runtime/documents：新建一个Document

-   GET /runtime/documents/{id}：获取由ID指定的Document

-   PUT /runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /runtime/documents/{id}：删除由ID指定的Document
```

### 1.3  **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。

```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```

参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，

```
GET /runtime/documents/{id}/flowhis
```

 与 

```
GET /runtime/flowhis?doc_id={id}
```

的含义是相同的。

### 1.4 **状态码（Status codes）**

------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。

```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
    
-  4001 INTERNAL SERVER ERROR -
    [\*]：服务器校验错误
```

### 1.5  **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

- API应该始终返回相应的状态码，以反映服务器或者请求的状态。
- API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。
- API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。
- JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：

```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

- 对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：

```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### 1.6 **数据结构（Data structure）**

- 在POST,PUT,PATCH上使用JSON作为输入。
- 注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
  media type）。
- 服务器返回的数据格式，统一使用JSON作为输出。

> 服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

> 参数说明：

| 参数    | 必须 | 说明                 |
| ------- | ---- | -------------------- |
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### 1.7 **其他**

------

1. 客户端控制服务端是否需要返回数据、且返回哪些数据的约定
2. Urls命名规则统一使用蛇形命名法（下划线和小写）





## **评论**

### 发表评论

**请求方式：** POST 

**请求地址：** /api/message/comment

**参数说明：**

无

**请求包体**：

```
{
	"attachment": "",
	"content": "我评论了",
	"lazyLoad": true,
	"messageId": "8Q9Jl0JXICP6s95ZRuD",
	"read": false,
	"toContent": "我发布公告了",
	"toUser": "CCC",
	"toUserId": "pyVVlAIzdRkiw6QZWTT",
	"version": 0
}
```

**权限说明：**

无

**返回结果：**

```
{
	"attachment": "",
	"content": "我评论了",
	"id": "125e4c44-20e4-431d-a2c8-9f68dba19783",
	"lazyLoad": true,
	"messageId": "8Q9Jl0JXICP6s95ZRuD",
	"read": false,
	"toContent": "我发布公告了",
	"toUser": "CCC",
	"toUserId": "pyVVlAIzdRkiw6QZWTT",
	"version": 0
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |

### 删除评论

**请求方式：** DELETE  
**请求地址：** /api/message/comment?commentId={commentId}&messageId={messageId}

**参数说明：**

| **参数**  | **必须** | **说明** |
| --------- | -------- | -------- |
| commentId | 是       | 评论id   |
| messageId | 是       |          |

**权限说明：**

无。

**返回结果：**

```
{"message":"删除成功","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 我回复的评论

**请求方式：** GET  
**请求地址：** /api/message/comment/my/reply

**参数说明：**

| **参数**  | **必须** | **说明**     |
| --------- | -------- | ------------ |
| telephone | 是       | 测试手机号码 |
| domainid  | 是       | 企业域id     |

**权限说明：**

无。

**返回结果：**

```
{
    "data":{
        "rowCount":1,
        "linesPerPage":30,
        "pageNo":1,
        "datas":[
            {
                "id":"qeNwg5s4irW35PIn6Du",
                "content":"回复 @CCC jljljljlj",
                "attachment":"",
                "createTime":"2019-10-17 09:51:50",
                "sender":"CCC",
                "senderId":"pyVVlAIzdRkiw6QZWTT",
                "messageId":"8Q9Jl0JXICP6s95ZRuD",
                "commentId":"BHQKA5KxtSEes4Tq75p",
                "toUser":"CCC",
                "toUserId":"pyVVlAIzdRkiw6QZWTT",
                "toContent":"sssq",
                "module":null,
                "read":true
            }
        ],
        "pageCount":1
    },
    "message":"",
    "status":1
}
```

**参数说明：**

| **参数**        | **说明**                 |
| --------------- | ------------------------ |
| errcode         | 返回码（0=成功，1=失败） |
| errmsg          | 对返回码的文本描述内容   |
| data            | 企业域集合               |
| data[0].type    | 提示类型                 |
| data[0].success | 提示消息                 |

### 回复我的评论

**请求方式：** GET  
**请求地址：** /api/message/comment/my/receive

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
    "data":{
        "rowCount":1,
        "linesPerPage":30,
        "pageNo":1,
        "datas":[
            {
                "id":"qeNwg5s4irW35PIn6Du",
                "content":"回复 @CCC jljljljlj",
                "attachment":"",
                "createTime":"2019-10-17 09:51:50",
                "sender":"CCC",
                "senderId":"pyVVlAIzdRkiw6QZWTT",
                "messageId":"8Q9Jl0JXICP6s95ZRuD",
                "commentId":"BHQKA5KxtSEes4Tq75p",
                "toUser":"CCC",
                "toUserId":"pyVVlAIzdRkiw6QZWTT",
                "toContent":"sssq",
                "module":null,
                "read":true
            }
        ],
        "pageCount":1
    },
    "message":"",
    "status":1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 消息下的评论列表

**请求方式：** GET
**请求地址：** /api/message/comment

**参数说明：**

**请求包体**：

```
无
```

**权限说明：**



**权限说明：**

无。

**返回结果：**

```
{
    "data":{
        "rowCount":1,
        "linesPerPage":30,
        "pageNo":1,
        "datas":[
            {
                "id":"qeNwg5s4irW35PIn6Du",
                "content":"回复 @CCC jljljljlj",
                "attachment":"",
                "createTime":"2019-10-17 09:51:50",
                "sender":"CCC",
                "senderId":"pyVVlAIzdRkiw6QZWTT",
                "messageId":"8Q9Jl0JXICP6s95ZRuD",
                "commentId":"BHQKA5KxtSEes4Tq75p",
                "toUser":"CCC",
                "toUserId":"pyVVlAIzdRkiw6QZWTT",
                "toContent":"sssq",
                "module":null,
                "read":true
            }
        ],
        "pageCount":1
    },
    "message":"",
    "status":1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



## **消息**

### 获取消息以及评论内容

**请求方式：** GET  
**请求地址：**  /api/message/messages

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
无
```

**权限说明：**



**权限说明：**

无。

**返回结果：**

```
找不到，到时在找
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



### 发布消息

**请求方式：** POST  
**请求地址：**/api/message/messages

**参数说明：**

无

**请求包体**：

```
{
	"comment": false,
	"commentCount": 0,
	"content": "我发布消息",
	"lazyLoad": true,
	"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"8h1xHsPjXW0qb7OSQo8\",\"deptName\":\"市场部\"}]}",
	"scope": 2,
	"sticky": false,
	"type": 0,
	"version": 0
}
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"id": "zXNIojbhzLGqUWta4cn",
		"title": null,
		"content": "lk",
		"attachment": "[]",
		"createTime": "2019-10-17 14:34:09",
		"sender": "CCC",
		"senderId": "pyVVlAIzdRkiw6QZWTT",
		"senderDept": "newDepartment",
		"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
		"scope": 2,
		"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"8h1xHsPjXW0qb7OSQo8\",\"deptName\":\"市场部\"}]}",
		"receiverId": "ZUNHIPmke4EDKJjhzmp",
		"receiverDeptId": "8h1xHsPjXW0qb7OSQo8",
		"commentCount": 0,
		"type": 0,
		"sticky": false,
		"comment": true,
		"module": null
	},
	"message": "发布成功",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



### 发布公告

**请求方式：** POST  
**请求地址：** /api/message/messages/announcement

**参数说明：**

无

**请求包体**：

```
{
	"comment": false,
	"commentCount": 0,
	"content": "我发布公告",
	"lazyLoad": true,
	"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"8h1xHsPjXW0qb7OSQo8\",\"deptName\":\"市场部\"}]}",
	"scope": 1,
	"sticky": false,
	"type": 0,
	"version": 0
}
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"id": "SH0zO8Tau0gT4xpjcQY",
		"title": "jkkkkkkkk",
		"content": "<p>jjkjkjjjjjjj</p>",
		"attachment": "",
		"createTime": "2019-10-17 14:44:29",
		"sender": "CCC",
		"senderId": "pyVVlAIzdRkiw6QZWTT",
		"senderDept": "newDepartment",
		"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
		"scope": 2,
		"receiverInfo": null,
		"receiverId": "ZUNHIPmke4EDKJjhzmp",
		"receiverDeptId": "8h1xHsPjXW0qb7OSQo8",
		"commentCount": 0,
		"type": 1,
		"sticky": false,
		"comment": false,
		"module": null
	},
	"message": "发布成功",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 部门详情                 |

### 删除信息

**请求方式：** DELETE
**请求地址：** /api/message/messages?messageId={messageId}

**参数说明：**

| **参数**  | **必须** | **说明** |
| --------- | -------- | -------- |
| messageId | 是       | 消息id   |

**请求包体**：

无

**权限说明：**

无。

**返回结果：**

```
{"message":"删除成功","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 查询消息列表查询(包含条件) 

**请求方式：** GET
**请求地址：**/api/message/messages/list?content={content}&linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **必须** | **说明** |
| ------------ | -------- | -------- |
| content      | 是       | 内容     |
| linesPerPage | 是       | 每页条数 |
| pageNo       | 是       | 页数     |

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"rowCount": 3,
		"linesPerPage": 30,
		"pageNo": 1,
		"datas": [{
			"id": "4ZEArcbWtwWAIxLIjVO",
			"title": null,
			"content": "kjkjkj",
			"attachment": "[]",
			"createTime": "2019-10-17 14:35:29",
			"sender": "CCC",
			"senderId": "pyVVlAIzdRkiw6QZWTT",
			"senderDept": "newDepartment",
			"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
			"scope": 2,
			"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"QRciJ526QiqnfcdLFQ3\",\"deptName\":\"CCCC\"}]}",
			"receiverId": "",
			"receiverDeptId": "",
			"commentCount": 0,
			"type": 0,
			"sticky": false,
			"comment": true,
			"module": null
		}, {
			"id": "81jv12SQjCS2EcVdb7g",
			"title": null,
			"content": "kklklk",
			"attachment": "[]",
			"createTime": "2019-10-17 14:33:37",
			"sender": "CCC",
			"senderId": "pyVVlAIzdRkiw6QZWTT",
			"senderDept": "newDepartment",
			"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
			"scope": 2,
			"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"8h1xHsPjXW0qb7OSQo8\",\"deptName\":\"市场部\"}]}",
			"receiverId": "ZUNHIPmke4EDKJjhzmp",
			"receiverDeptId": "8h1xHsPjXW0qb7OSQo8",
			"commentCount": 0,
			"type": 0,
			"sticky": false,
			"comment": true,
			"module": null
		}, {
			"id": "8Q9Jl0JXICP6s95ZRuD",
			"title": null,
			"content": "AASS",
			"attachment": "[]",
			"createTime": "2019-10-17 09:10:51",
			"sender": "CCC",
			"senderId": "pyVVlAIzdRkiw6QZWTT",
			"senderDept": "newDepartment",
			"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
			"scope": 2,
			"receiverInfo": "{\"user\":[],\"dept\":[{\"deptId\":\"8h1xHsPjXW0qb7OSQo8\",\"deptName\":\"市场部\"}]}",
			"receiverId": "ZUNHIPmke4EDKJjhzmp",
			"receiverDeptId": "8h1xHsPjXW0qb7OSQo8",
			"commentCount": 1,
			"type": 0,
			"sticky": false,
			"comment": true,
			"module": null
		}],
		"pageCount": 1
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 查询公告型消息列表(包含条件) 

**请求方式：** GET  
**请求地址：** /api/message/messages/announcement?content={content}&linesPerPage={linesPerPage}&pageNo={pageNo}



**参数说明：**

| **参数**     | **必须** | **说明** |
| ------------ | -------- | -------- |
| content      | 是       | 内容     |
| linesPerPage | 是       | 每页条数 |
| pageNo       | 是       | 页数     |

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"rowCount": 1,
		"linesPerPage": 30,
		"pageNo": 1,
		"datas": [{
			"id": "X1D0GIwdtnjtfm0nyZ9",
			"title": "klk",
			"content": "<p>klk</p>",
			"attachment": "",
			"createTime": "2019-10-17 15:03:11",
			"sender": "CCC",
			"senderId": "pyVVlAIzdRkiw6QZWTT",
			"senderDept": "newDepartment",
			"senderDeptId": "2GRc9uflP5C0Vw9eCO5",
			"scope": 2,
			"receiverInfo": null,
			"receiverId": "ZUNHIPmke4EDKJjhzmp",
			"receiverDeptId": "8h1xHsPjXW0qb7OSQo8",
			"commentCount": 0,
			"type": 1,
			"sticky": false,
			"comment": false,
			"module": null
		}],
		"pageCount": 1
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 查看预览文件

**请求方式：** GET
**请求地址：** /api/message/messages/attachement/preview?id={id}&extName={extName}&url={url}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id | 是 | 文件id |
| extName | 是 | 后缀名 |
| url | 是 | 文件路径 |

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"origPath": "C:\\project\\obpm22\\src\\main\\webapp/uploads/message/2019/11e9-f0ac-7ba39506-87bc-135c9e77df9d.docx",
		"is2SWF": "false",
		"swfPath": "C:\\project\\obpm22\\src\\main\\webapp/uploads/message/2019//swf/11e9-f0ac-7ba39506-87bc-135c9e77df9d.swf"
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## **事项提醒**

### 获取事项提醒

**请求方式：** GET  
**请求地址：** /api/message/notice?readStatus={readStatus}&type={type}&linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**  

| **参数**     | **必须** | **说明**        |
| :----------- | -------- | --------------- |
| readStatus   | 是       | 未读：0   读：1 |
| type         | 是       | 后续补充        |
| linesPerPage | 是       | 每页条数        |
| pageNo       | 是       | 页数            |

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"rowCount": 1,
		"linesPerPage": 30,
		"pageNo": 1,
		"datas": [{
			"id": "NeP9OdoZigTlntn4dvC",
			"summary": "<span class='notice_type' type='3'></span><span class='notice_actor'>CCC</span><span class='notice_flowType'>创建</span><span class='notice_flow'>审批单</span><span class='notice_summary'>请假单_自由流程-CCC创建请假单_自由流程</span>",
			"content": "{\"content\":\"CCC创建请假单_自由流程\",\"event\":\"发起\",\"type\":3}",
			"toUserId": "pyVVlAIzdRkiw6QZWTT",
			"createTime": "2019-07-11 18:46:44",
			"read": false,
			"module": "自由流程",
			"linkParams": "{\"_docid\":\"RtCYmbpQ0gLah7SuKP8\",\"_formid\":\"OGMmff1QTZYqFk5vfeD\",\"application\":\"HdPeBqYwJyFyjHkhZu3\",\"mode\":\"personalMessageMode\"}",
			"subjectType": 3
		}],
		"pageCount": 1
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 删除事项提醒通知

**请求方式：** DELETE 
**请求地址：** /api/message/notice?noticeId={noticeId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| noticeId | 是       |     通知事项id     |

**权限说明：**

无。

**返回结果：**

```
{"message":"","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 设置事项提醒通知为已读

**请求方式：** PUT  
**请求地址：** /api/message/notice/read?noticeId={noticeId}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| noticeId | 是       | 通知id   |

**权限说明：**

无。

**返回结果：**

```
{"message":"","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |



### 标记所有未读通知为已读

**请求方式：** PUT
**请求地址：** /api/message/notice/allRead

**参数说明：**

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{"message":"","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 

## 消息中心

### 用户登录时，获取消息通知

**请求方式：** GET
**请求地址：**/api/message/notification/login

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 用户id   |

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"3": 0,
		"2": 0,
		"size": 0
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 获取消息中心通知

**请求方式：** GET  
**请求地址：** /api/message/notification

**参数说明：**

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{
	"data": {
		"data": [],
		"amount": {
			"notice": 0,
			"comment": 0,
			"sum": 0
		}
	},
	"message": "",
	"status": 1
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 清空消息中心通知

**请求方式：** DELETE  
**请求地址：** /api/message/notification/clear

**参数说明：**

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{"message":"","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 获得消息总数

**请求方式：** GET  
**请求地址：**/api/message/notification/count

**参数说明：**

**请求包体**：

```
无
```

**权限说明：**

无。

**返回结果：**

```
{"data":{"notice":0},"message":"","status":1}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

